/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.time.DurationFormatUtils;
import pregenerator.common.generator.ChunkProcessor;
import pregenerator.common.manager.IProcess;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ChunkLogger {
    Task{

        @Override
        public void append(MutableComponent text, ChunkProcessor processor) {
            text.m_7220_((Component)1.wrap(new TextComponent("Task Name: " + processor.getTaskName()).m_130940_(ChatFormatting.RED)));
        }
    }
    ,
    World{

        @Override
        public void append(MutableComponent text, ChunkProcessor processor) {
            text.m_7220_((Component)2.wrap(new TextComponent("World: " + 2.toPascalCase(processor.getTask().getDimension().m_135782_().m_135815_())).m_130940_(ChatFormatting.GREEN))).m_130946_(" ");
            text.m_7220_((Component)2.wrap(new TextComponent("Task Type: " + processor.process.getTaskType()).m_130940_(ChatFormatting.DARK_AQUA)));
        }
    }
    ,
    TaskInfo{

        @Override
        public void append(MutableComponent text, ChunkProcessor processor) {
            text.m_7220_((Component)3.wrap(new TextComponent("Task (Main : Light/Total) (" + IProcess.FORMAT.format(processor.gen_speed.getLastValue()) + " : " + IProcess.FORMAT.format(processor.light_speed.getLastValue()) + ") / " + IProcess.FORMAT.format(processor.process.getTotalChunks())).m_130940_(ChatFormatting.BLUE)));
        }
    }
    ,
    ProcessingSpeed{

        @Override
        public void append(MutableComponent text, ChunkProcessor processor) {
            text.m_7220_((Component)4.wrap(new TextComponent("Speed (Main | Light): " + ItemStack.f_41584_.format(processor.mainQueue.isNotWorking() && processor.process.isDone() ? 0.0 : (double)processor.gen_speed.getTotalValue()) + " Chunks/t | " + ItemStack.f_41584_.format(processor.lightQueue.isNotWorking() ? 0.0 : (double)processor.light_speed.getTotalValue()) + " Chunks/t").m_130940_(ChatFormatting.AQUA)));
        }
    }
    ,
    LoadedFiles{

        @Override
        public void append(MutableComponent text, ChunkProcessor processor) {
            if (processor.process.hasLithium()) {
                text.m_7220_((Component)5.wrap(new TextComponent("Loaded (Chunks | RegionFiles | POI): " + processor.process.getLoadedChunks() + " | " + processor.process.getActiveRegionFiles() + " | " + processor.process.getPointsOfInterest()).m_130940_(ChatFormatting.GOLD)));
            } else {
                text.m_7220_((Component)5.wrap(new TextComponent("Loaded (Chunks | RegionFiles | POI): " + processor.process.getLoadedChunks() + " | " + processor.process.getActiveRegionFiles() + " | " + processor.process.getPointsOfInterest()).m_130940_(ChatFormatting.GOLD)));
            }
        }
    }
    ,
    ExpectedTime{

        @Override
        public void append(MutableComponent text, ChunkProcessor processor) {
            long total = processor.process.getTotalChunks();
            long normalLeft = (long)((float)(total - processor.normalDone) / processor.gen_speed.getTotalValue()) * 50L;
            long lightLeft = (long)((float)(total - processor.lightDone) / processor.light_speed.getTotalValue()) * 50L;
            text.m_7220_((Component)6.wrap(new TextComponent("Time Left (Main | Light), Running: " + this.getTime(normalLeft) + " | " + this.getTime(lightLeft) + ", " + processor.getTime()).m_130940_(ChatFormatting.GREEN)));
        }
    }
    ,
    RamUsage{

        @Override
        public void append(MutableComponent text, ChunkProcessor processor) {
            text.m_7220_((Component)7.wrap(new TextComponent("Ram Usage: " + 7.toMB(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) + " MB / " + 7.toMB(Runtime.getRuntime().maxMemory()) + " MB").m_130940_(ChatFormatting.LIGHT_PURPLE)));
            text.m_7220_((Component)7.wrap(new TextComponent("Ticks: " + processor.process.getWorld().m_183326_().m_183574_() + " | " + processor.process.getWorld().m_183324_().m_183574_()).m_130940_(ChatFormatting.BLUE)));
        }
    };


    public static MutableComponent wrap(MutableComponent text) {
        return new TextComponent("[").m_7220_((Component)text).m_130946_("]");
    }

    protected String getTime(long time) {
        return DurationFormatUtils.formatDuration((long)Math.abs(time), (String)"HH:mm:ss");
    }

    public void append(MutableComponent text, ChunkProcessor processor) {
    }

    public static String toPascalCase(String input) {
        StringBuilder builder = new StringBuilder();
        for (String s : input.replaceAll("_", " ").replaceAll("-", " ").split(" ")) {
            builder.append(ChunkLogger.firstLetterUppercase(s)).append(" ");
        }
        return builder.substring(0, builder.length() - 1);
    }

    public static long toMB(long base) {
        return base >> 20;
    }

    public static String firstLetterUppercase(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        String first = Character.toString(string.charAt(0));
        return string.replaceFirst(first, first.toUpperCase());
    }
}

